#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define N 20

enum { SMER_A, SMER_B, NEMA };
enum { AUTOMOBIL, AUTOBUS, KAMION };

int smer = NEMA;
int naNadvoznjaku = 0;
int brojAutomobila = 0;
int imaAutobus = 0;
int imaKamion = 0;

pthread_mutex_t mutex;
pthread_cond_t cond;

void* doWork(void *arg)
{
    long id = (long) arg;

    int tipVozila = rand() % 3;
    int smerMoj = rand() % 2;

    int time = rand() % 10 + 1;
    sleep(time);

    if (smerMoj == SMER_A)
    {
        if (tipVozila == AUTOMOBIL)
        {
            // printf("Automobil %ld iz smera A je stigao do nadvoznjaka u t=%d\n", id, time);

            pthread_mutex_lock(&mutex);

            while ((imaKamion) ||
                   (smer == SMER_B && naNadvoznjaku > 0)
            )
                pthread_cond_wait(&cond, &mutex);

            naNadvoznjaku++;
            brojAutomobila++;
            smer = SMER_A;

            pthread_mutex_unlock(&mutex);

            printf("Automobil %ld prelazi iz smera A...\n", id);
            sleep(3);
            printf("Automobil %ld PRESAO iz smera A\n", id);

            pthread_mutex_lock(&mutex);

            naNadvoznjaku--;
            brojAutomobila--;

            if (naNadvoznjaku == 0)
                smer = NEMA;

            pthread_cond_broadcast(&cond);

            pthread_mutex_unlock(&mutex);
        }
        else if (tipVozila == AUTOBUS)
        {
            // printf("Autobus %ld iz smera A je stigao do nadvoznjaka u t=%d\n", id, time);

            pthread_mutex_lock(&mutex);

            while ((imaKamion) ||
                   (imaAutobus) ||
                   ((smer == SMER_B) && (naNadvoznjaku > 0))
            )
                pthread_cond_wait(&cond, &mutex);

            naNadvoznjaku++;
            imaAutobus = 1;
            smer = SMER_A;

            pthread_mutex_unlock(&mutex);

            printf("Autobus %ld prelazi iz smera A...\n", id);
            sleep(3);
            printf("Autobus %ld PRESAO iz smera A\n", id);

            pthread_mutex_lock(&mutex);

            naNadvoznjaku--;
            imaAutobus = 0;

            if (naNadvoznjaku == 0)
                smer = NEMA;

            pthread_cond_broadcast(&cond);

            pthread_mutex_unlock(&mutex);
        }
        else if (tipVozila == KAMION)
        {
            // printf("Kamion %ld iz smera A je stigao do nadvoznjaka u t=%d\n", id, time);

            pthread_mutex_lock(&mutex);

            while ((naNadvoznjaku > 0) || (smer == SMER_B))
                pthread_cond_wait(&cond, &mutex);

            naNadvoznjaku++;
            imaKamion = 1;
            smer = SMER_A;

            pthread_mutex_unlock(&mutex);

            printf("Kamion %ld prelazi iz smera A...\n", id);
            sleep(3);
            printf("Kamion %ld PRESAO iz smera A\n", id);

            pthread_mutex_lock(&mutex);

            naNadvoznjaku--;
            imaKamion = 0;

            if (naNadvoznjaku == 0)
                smer = NEMA;

            pthread_cond_broadcast(&cond);

            pthread_mutex_unlock(&mutex);
        }
        else
        {
            printf("Nevalidan tip vozila\n");
            exit(1);
        }
    }
    else if (smerMoj == SMER_B)
    {
        if (tipVozila == AUTOMOBIL)
        {
            // printf("Automobil %ld iz smera B je stigao do nadvoznjaka u t=%d\n", id, time);

            pthread_mutex_lock(&mutex);

            while ((imaKamion) ||
                   ((smer == SMER_A) && (naNadvoznjaku > 0))
            )
                pthread_cond_wait(&cond, &mutex);

            naNadvoznjaku++;
            brojAutomobila++;
            smer = SMER_B;

            pthread_mutex_unlock(&mutex);

            printf("Automobil %ld prelazi iz smera B...\n", id);
            sleep(3);
            printf("Automobil %ld PRESAO iz smera B\n", id);

            pthread_mutex_lock(&mutex);

            naNadvoznjaku--;
            brojAutomobila--;

            if (naNadvoznjaku == 0)
                smer = NEMA;

            pthread_cond_broadcast(&cond);

            pthread_mutex_unlock(&mutex);
        }
        else if (tipVozila == AUTOBUS)
        {
            // printf("Autobus %ld iz smera B je stigao do nadvoznjaka u t=%d\n", id, time);

            pthread_mutex_lock(&mutex);

            while ((imaKamion) ||
                   (imaAutobus) ||
                   ((smer == SMER_A) && (naNadvoznjaku > 0))
            )
                pthread_cond_wait(&cond, &mutex);

            naNadvoznjaku++;
            imaAutobus = 1;
            smer = SMER_B;

            pthread_mutex_unlock(&mutex);

            printf("Autobus %ld prelazi iz smera B...\n", id);
            sleep(3);
            printf("Autobus %ld PRESAO iz smera B\n", id);

            pthread_mutex_lock(&mutex);

            naNadvoznjaku--;
            imaAutobus = 0;

            if (naNadvoznjaku == 0)
                smer = NEMA;

            pthread_cond_broadcast(&cond);

            pthread_mutex_unlock(&mutex);
        }
        else if (tipVozila == KAMION)
        {
            // printf("Kamion %ld iz smera B je stigao do nadvoznjaka u t=%d\n", id, time);

            pthread_mutex_lock(&mutex);

            while ((naNadvoznjaku > 0) || (smer == SMER_A))
                pthread_cond_wait(&cond, &mutex);

            naNadvoznjaku++;
            imaKamion = 1;
            smer = SMER_B;

            pthread_mutex_unlock(&mutex);

            printf("Kamion %ld prelazi iz smera B...\n", id);
            sleep(3);
            printf("Kamion %ld PRESAO iz smera B\n", id);

            pthread_mutex_lock(&mutex);

            naNadvoznjaku--;
            imaKamion = 0;

            if (naNadvoznjaku == 0)
                smer = NEMA;

            pthread_cond_broadcast(&cond);

            pthread_mutex_unlock(&mutex);
        }
        else
        {
            printf("Nevalidan tip vozila\n");
            exit(1);
        }
    }
    else
    {
        printf("Nevalidan smer\n");
        exit(1);
    }
}

int main()
{
    srand(time(NULL));

    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&cond, NULL);

    pthread_t threads[N];

    for (long i = 0; i < N; i++)
        pthread_create(threads + i, NULL, doWork, (void *) i);

    for (long i = 0; i < N; i++)
        pthread_join(threads[i], NULL);

    printf("Main: Sve niti su zavrsile sa radom.\n");

    pthread_exit(NULL);
}